<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Personas extends CI_Controller {
	public $id;
	public $eliminado;
	public function __construct()
    {
        parent::__construct();
        $this->load->library('session');
          
        $this->load->model('model_persona');
        $this->id = $this->input->get('id')?$this->input->get('id'):'';
        $this->eliminado = $this->input->get('eliminado')?$this->input->get('eliminado'):0;
        

    }  
	
	public function index()
	{
		echo 'Personas';	
	}
	public function listar()
	{
		$respuesta = $this->model_persona->listar($this->eliminado);
		echo json_encode($respuesta);
	}
	public function copiar()
	{
		$data = $this->model_persona->registro($this->input->post('id'));
		unset($data->pe_codigo);
		$data->pe_nombres = strtoupper( $this->input->post('nombre'));
		$data->pe_nombre_comercial = strtoupper( $this->input->post('nombre'));
		$persona = $this->model_persona->guardar($data);
		if ($this->db->trans_status() == FALSE)
		{
			$respuesta = array('error' => '1','mensaje'=>'No se Pudo Copiar' );
		    
		}else{
			$respuesta = array('pe_codigo'=> $persona['pe_codigo'] , 'error' => '0','mensaje'=>'Se copio correctamente' );
		}
		echo json_encode($respuesta);
	}
	public function eliminar()
	{
		$id = $this->input->post('id');
		if ($id ) {
			$this->db->trans_start();
			$data = array('pe_eliminado' => 1  );
			$respuesta = $this->model_persona->actualizar($id ,$data);
			$this->db->trans_complete();

			if ($this->db->trans_status() == FALSE)
			{
				$respuesta = array('error' => '1','mensaje'=>'No se Pudo Eliminar' );
			    
			}else{
				$respuesta = array('se_codigo'=>$id , 'error' => '0','mensaje'=>'Se Elimino correctamente' );
			}
		}else{
			$respuesta = array('error' => '1','mensaje'=>'Persona no encontrada' );
			
		}
		echo json_encode($respuesta);
	}
	public function eliminar_padre()
	{
		$id = $this->input->post('id');
		if ($id ) {
			$this->db->trans_start();
			$data = array('se_eliminado' => 1  );
			$this->model_persona->actualizar($id ,$data);
			$this->model_persona->actualizar_hijos($id ,$data);
			$this->db->trans_complete();

			if ($this->db->trans_status() == FALSE)
			{
				$respuesta = array('error' => '1','mensaje'=>'No se Puedo Eliminar el Servicio' );
			    
			}else{
				$respuesta = array('se_codigo'=>$id , 'error' => '0','mensaje'=>'Se Elimino correctamente el Servicio' );
			}
		}else{
			$respuesta = array('error' => '1','mensaje'=>'Servicio no encontrado' );
			
		}
		echo json_encode($respuesta);
	}
}
