<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class model_tipos_existencias extends CI_Model {
	public function listar(){
        $this->db->where('te_estado',1);
		return $this->db->get('tipos_existencias')->result();
	}
    public function registro($id){
        $this->db->where('te_id',$id);
        $this->db->where('te_estado',1);
		return $this->db->get('tipos_existencias')->row();
	}
    public function buscar($termino){
        $this->db->like('te_tipo_existencia',$termino);
        $this->db->where('te_estado',1);
		return $this->db->get('tipos_existencias')->result();
	}
    public function guardar($array){
     	$this->db->trans_start();
        if ( !$this->db->insert('tipos_existencias', $array)){
            $error = $this->db->error();
            return $error;
        }else{
           $id =  $this->db->insert_id();
        }
     	$this->db->trans_complete();
        return $id;	
     }
     public function actualizar($id,$array){
     	$this->db->trans_start();
        $this->db->where('te_id', $id);
     	$this->db->update('tipos_existencias', $array);
     	$this->db->trans_complete();
     }
     public function remover($id){
     	$this->db->trans_start();
        $data = array();
        $this->db->set('te_estado',0);
        $this->db->where('te_id', $id)->update('tipos_existencias', $data);
     	$this->db->trans_complete();	
     }
	public function eliminar($id){
		$this->db->where('te_id',$id);
		$this->db->delete('tipos_existencias');	
	}


}
?>