<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class model_stock extends CI_Model {
	public function listar(){
        $this->db->select('sk.*,pd.pd_producto, us_nombres,pe.pe_nombre,pe.pe_apellido');
        $this->db->from('stock sk');
        $this->db->join('productos pd', 'sk.sk_id_pd = pd.pd_id');
        $this->db->join('personas pe', 'sk.sk_id_pe = pe.pe_id');
        $this->db->join('usuarios us', 'sk.sk_id_us_reg = us.us_id');
        $this->db->where('sk.sk_id_gr',$this->igr);
        return $this->db->get()->result();
	}
    public function listar_x_almacen($ial){
        $this->db->select('sk.*,pd_id,pd_id_un, pd_producto, pd_stock_min, pd_precio_venta, un_unidad');
        $this->db->from('stock sk');
        $this->db->join('productos pd', 'sk.sk_id_pd = pd.pd_id');
        $this->db->join('unidades un', 'pd.pd_id_un = un.un_id','left');
        $this->db->where('sk.sk_id_gr',$this->igr);
        $this->db->where('sk.sk_id_al',$ial);
        return $this->db->get()->result();
    }
    public function listar_x_producto($ipd){
        $this->db->select('sk.*');
        $this->db->from('stock sk');        
        $this->db->where('sk.sk_id_pd',$ipd);
        $this->db->where('sk.sk_id_gr',$this->igr);
        return $this->db->get()->result();
    }
  
  
    public function registro($ial,$ipd){
        $this->db->where('sk_id_al',$ial);
        $this->db->where('sk_id_pd',$ipd);
		return $this->db->get('stock')->row();
	}

    public function buscar($termino){
        $this->db->like('sk_producto',$termino);
        $this->db->where('sk_estado',1);
		return $this->db->get('stock')->result();
	}
    public function guardar($array){
        if ( !$this->db->insert('stock', $array)){
            $respuesta = $this->db->error();
        }else{
           $respuesta = array('id'=> $this->db->insert_id());
        }

        return $respuesta;	
    }
    public function actualizar($ial,$ipd,$array){
        $this->db->where('sk_id_al', $ial);
        $this->db->where('sk_id_pd', $ipd);
     	$this->db->update('stock', $array);
    }

     public function remover($id){
     	$this->db->trans_start();
        $data = array();
        $this->db->set('sk_estado',0);
        $this->db->where('sk_id', $id)->update('stock', $data);
     	$this->db->trans_complete();	
     }
	public function eliminar($id){
		$this->db->where('sk_id',$id);
		$this->db->delete('stock');	
	}

    public function listar_para_requerimiento(){
        //primero: deben ser productos bajos en stock
        $this->db->select('sk.sk_stock,sk.sk_stock_min,pd_id,pd_id_un, pd_producto,pd_es_padre, pd_precio_venta, fa_familia, un_unidad');
        $this->db->from('stock sk');
        $this->db->join('productos pd', 'sk.sk_id_pd = pd.pd_id');
        $this->db->join('familias fa', 'pd.pd_id_fa = fa.fa_id','left');
        $this->db->join('unidades un', 'pd.pd_id_un = un.un_id','left');
        $this->db->where('sk.sk_id_gr',$this->igr);
        $this->db->where('pd.pd_control_stock',1);
        $this->db->where('sk.sk_stock <= sk.sk_stock_min');
        return $this->db->get()->result();
    }
}
?>