<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class model_productos extends CI_Model {
	public function listar($igr,$ist){
        $this->db->select("pd.*,un.un_unidad");
        $this->db->from('productos pd');
        $this->db->join('unidades un', 'pd.pd_id_un = un.un_id','left');
        $this->db->order_by('pd.pd_producto', 'ASC');
        if ($ist) {
          $this->db->where('pd_estado',$ist);
        }     
        return $this->db->get()->result();
        echo $this->db->last_query();
	}
  public function listar_control_Stock(){
        $this->db->select("pd.*,un.un_unidad");
        $this->db->from('productos pd');
        $this->db->join('unidades un', 'pd.pd_id_un = un.un_id','left');
        $this->db->order_by('pd.pd_producto', 'ASC');
        $this->db->where('pd_control_Stock',1);
          $this->db->where('pd_estado',1);
        return $this->db->get()->result();
        echo $this->db->last_query();
  }
  public function listar_activos_venta(){
        $this->db->select("pd.*, fa.fa_familia,fa_id");
        $this->db->from('productos pd');
        $this->db->join('familias fa', 'pd.pd_id_fa=fa.fa_id');
        $this->db->where('pd_id_gr',$this->igr);
        $this->db->where('pd_estado',1);
        $this->db->where('pd_activo_venta',1);
        $this->db->order_by('pd_id_fa','asc');
        return $this->db->get()->result();
  }
  public function listar_hijos($id_padre){
        $this->db->select('pd_id, pd_producto,pd_cantidad,pd_id_un,un_unidad,pd_estado, pd_precio_compra,pd_precio_compra_id_mo');
        $this->db->from('productos');
        $this->db->join('unidades','pd_id_un=un_id');
        $this->db->where('pd_id_padre',$id_padre);
        return $this->db->get()->result();
  }
  public function listar_activos($st = 1){
        $this->db->select("pd.*, fa.fa_familia,mr.mr_marca,un.un_unidad");
        $this->db->from('productos pd');
        $this->db->join('familias fa', 'pd.pd_id_fa = fa.fa_id');
        $this->db->join('marcas mr', 'pd.pd_id_mr = mr.mr_id');
        $this->db->join('unidades un', 'pd.pd_id_un = un.un_id');
        $this->db->where('pd_estado',$st);
        return $this->db->get()->result();
        //echo $this->db->lasquery();
  }
  public function listar_activos_almacen($almacen){
        $this->db->select("pd.*,un.un_unidad,sk_id_al, sk.sk_stock");
        $this->db->from('productos pd');
        $this->db->join('unidades un', 'pd.pd_id_un = un.un_id','left');
        $this->db->join('stock sk', 'sk.sk_id_pd=pd.pd_id','left');
        $this->db->where('pd_estado',1);
        if($almacen!='0')
          $this->db->where('sk_id_al',$almacen);
        return $this->db->get()->result();
       echo $this->db->last_query();
  }
  public function stock($almacen){
        
        $this->db->from('stock');
        $this->db->where('sk_id_al',$almacen);
        return $this->db->get()->result();
       // echo $this->db->lasquery();
  }
  public function listar_baja(){
        $this->db->select("*");
        $this->db->from('productos pd');
        $this->db->join('comprobantes_detalles', 'pd_id = cde_id_pd');
        $this->db->join('comprobantes', 'cmp_id = cde_id_cmp');
        $this->db->where('cmp_id_tipo_operacion',9);
        return $this->db->get()->result();
  }
    public function listar_xfamilia($ifa){
          $this->db->select('pd_id, pd_producto');
          $this->db->where('pd_id_fa',$ifa);
          $this->db->order_by('pd_producto','ASC');
          return $this->db->get('productos')->result();
    }
    public function listar_pedido(){
        $this->db->select('pd.*, fa.fa_familia,mr.mr_marca,(pd_stock_actual-pd_stock_min) as n');
        $this->db->from('productos pd');
        $this->db->join('familias fa', 'pd.pd_id_fa = fa.fa_id');
        $this->db->join('marcas mr', 'pd.pd_id_mr = mr.mr_id');
        $this->db->where('pd_estado',1);
        $this->db->order_by('n asc ');
     
        return $this->db->get()->result();
        //echo $this->db->lasquery();
        
    
    }
     public function contar_stock(){
        $query=$this->db->query('EXEC sp_contar_stock;');
        return $query->resularray();
     
        
    
    }
    public function compras_mes(){
        $query=$this->db->query('EXEC sp_compras_mes;');

        if($query){
          $result = $query->resularray();
          $c=0;
          foreach ($result as $item) {
            $result[$c]['mes']=aMes($item['mes']);
            $c++;
          }
        }
        else
          $result=  Array (0 => Array("ime" =>"Error"));
        $query->free_result();
        return $result;


    
        return $query->resularray();
    }
    public function registro($id){
      $this->db->select("pd.*");
        $this->db->from('productos pd');
        $this->db->where('pd_id',$id);
        return $this->db->get()->row();

	}
    public function buscar($igr, $termino){

        $this->db->select('pd_id, pd_producto as value, pd_precio_venta, pd_precio_venta_id_mo, pd_precio_compra, pd_precio_compra_id_mo,pd_id_un,pd_es_padre');
        $this->db->like('pd_producto',$termino);
        $this->db->where('pd_estado',1);
        $this->db->where('pd_id_padre',null);
        $this->db->where('pd_id_gr',$igr);
		    return $this->db->get('productos')->result();
	}
    public function guardar($array){

        if ( !$this->db->insert('productos', $array)){
            $data = $this->db->error();
            return $data;
        }else{
           $data  = array('pd_id' => $this->db->insert_id(), 'error'=>0,'message'=> 'se guardo');
        }
   
        return $data;	
     }
     public function actualizar($id,$array){

        $this->db->where('pd_id', $id);

        if ( !$this->db->update('productos', $array)){
            $data = $this->db->error();
        }else{
            $data  = array('pd_id' => $id, 'error'=>0,'message'=> 'Se actualizo correctamente');
        }
   
        return $data; 

     }
     public function actualizar_stock($id,$cant,$tipo_io,$data_producto){
        $operacion = $tipo_io == 'I'? '+':'-';
        $this->db->set('pd_stock_actual', 'pd_stock_actual '.$operacion.' '.$cant, FALSE);
        $this->db->where('pd_id', $id);
        $this->db->update('productos');
        $this->db->insert('productos_almacen_stock', $data_producto);
     }
     
   
     public function restaurar($id){
      $this->db->trans_start();
        $data = array();
        $this->db->set('pd_estado',1);
        $this->db->where('pd_id', $id)->update('productos', $data);
      $this->db->trans_complete();  
     }
	public function eliminar($id){
		$this->db->where('pd_id',$id);
		$this->db->delete('productos');	
	}


}
?>