<?php 
class Almacen extends CI_Controller
{
    public $id;
    public $iar;
    public $ius;
    public $id_pe;
    public $igr;
    public $ilo;
    public $f;
    public $f_fin;
    public $me;
    public $sme;
    public function __construct()
     {
          parent::__construct();
          $this->load->library('session');
          $this->load->helper('funciones');
          
          $this->load->model('model_seguridad');
          //$this->load->model('model_comprobantes_detalles');
          //$this->load->model('model_ordenes_compras_detalles');
          //$this->load->model('model_comprobantes');
          $this->load->model('model_kardex');
          $this->load->model('model_stock');
          $this->load->model('model_productos');
          //$this->load->model('model_areas');
          //$this->load->model('model_tipos');  
          $this->iar = $this->input->get('iar');
          $this->id = $this->input->get('i');
          $this->ius = 1;
          $this->id_pe = $this->session->userdata('id_pe');
          $this->ilo = $this->session->userdata('hs_id');
          $this->igr = $this->session->userdata('gr_id');

          $this->me = $this->input->get('me');
          $this->sme = $this->input->get('sme');
          $this->f = @$this->input->get('f')? $this->input->get('f'): date('Y-m-d');
          $this->f_fin = @$this->input->get('f_fin')? $this->input->get('f_fin'): date('Y-m-d');
    }     
    public function index(){
          $this->load->library('session');
          $this->load->view('header'); 
          $this->model_seguridad->SessionActivo();
          $data['almacenes'] = $this->model_areas->listar_xtipo(2);
          $this->load->view('view_almacen', $data);
          $this->load->view('footer');
	  }
   
   
    public function requerimientos_guardar(){
      //solicitar productos restaurante a administracion

        $tpc = 103; // 101 Nota de Pedido almacen

        $this->db->trans_start();
        $ultimo_numero = $this->model_comprobantes->ultimo_numero(1,$tpc,1);
        $data = array(
              'cmp_id_pe' => $this->id_pe,
              'cmp_id_tpc' => $tpc,
              'cmp_id_tipo_operacion' => 101,
              'cmp_serie' => 1,
              'cmp_numero' => ($ultimo_numero->cmp_numero + 1),
              'cmp_id_are' => $this->input->post('cmp_id_are'),
              'cmp_fecha' => $this->input->post('cmp_fecha'),
              'cmp_id_almacen' => 10,
              'cmp_id_us_reg' => $this->ius
        );
        $id_cmp = $this->model_comprobantes->guardar_comprobante($data);
            
        
        foreach ($this->input->post('cantidad') as $key=>$value) {
          $data = array(
                'cde_id_cmp' => $id_cmp,
                'cde_id_pd' => $key,
                'cde_cantidad' => $value,
                'cde_id_un' => $this->input->post('unidad')[$key],
                'cde_cantidad_almacen' => 0,
          );
          $this->model_comprobantes_detalles->guardar_requerimiento($data);  
        }
        $this->db->trans_complete();
      
            
            $destinatario      = 'betsi@casasanblas.com';
          
            $asunto = 'Nuevo Requerimiento Nro:'.($ultimo_numero->cmp_numero + 1).'';
            $mensaje = 'Sra Betsi,Tiene un nuevo requerimiento.';
            $cabecera = 'From: Restaurante Tika<sistemas@pebhlseguro.com>' . "\r\n" .
                //'Reply-To: '.$cc . "\r\n" .
                //'Cc: '.$cc. "\r\n" .
                'X-Mailer: PHP/' . phpversion();

            mail($destinatario, $asunto, $mensaje, $cabecera);
        $accion = "?c=almacen&m=view_almacenes_requerimientos_nuevo&save=true";
        redirect($accion.'&me='.$this->me.'&sme='.$this->sme);
      
            
    }
    public function stock(){
          //$this->model_seguridad->SessionActivo();  
          
          $this->iar = 1;
          
          $data['productos'] = $this->model_productos->listar_activos_almacen($this->iar);
          $data['stock']= $this->model_stock->listar_x_almacen($this->iar);
          $this->load->view('view_header');  
          $this->load->view('view_productos_stock', $data);  
    }
    public function kardex_json(){
        $data= $this->model_kardex->listar_movimientos($_GET['ial'],$_GET['ipd']);
        echo json_encode($data);
    }
    public function guardar_movimiento(){
        $cantidad = $this->input->get('tx_operacion')=='E'?$this->input->get('tx_cantidad'):$this->input->get('tx_cantidad')*-1;
          $kardex = array(
              'kx_id_al'=>$this->input->get('tx_id_al'),
              'kx_tipo' =>$this->input->get('tx_id_tp'),
              'kx_operacion' =>$this->input->get('tx_operacion'),
              'kx_id_pd'=>$this->input->get('tx_id_pd'),
              'kx_cantidad'=>$cantidad,
              'kx_id_un'=>$this->input->get('tx_id_un'),
              'kx_precio'=>$this->input->get('tx_precio'),
              'kx_id_fl'=>$this->input->get('tx_id_fl'),
              'kx_observacion' =>$this->input->get('tx_observacion'),
              'kx_id_us_reg' =>$this->ius,
              'kx_fecha' =>date('Y-m-d H:i'),
            );
          $data = $this->model_kardex->guardar($kardex);
          echo json_encode($data);
     }

     public function baja(){
          $this->load->library('session');
          $id_almacen = @$this->input->get('id_almacen')?$this->input->get('id_almacen'):1;
          if($this->input->post()){
            $kardex = array(
              'kx_id_al'=>$this->input->post('hi_almacen'),
              'kx_tipo' => 'B',
              'kx_id_pd'=>$this->input->post('hi_producto'),
              'kx_cantidad'=>$this->input->post('tx_cantidad'),
              'kx_observacion' =>$this->input->post('tx_observaciones'),
              'kx_id_us_reg' =>$this->ius
            );
            $this->model_productos->actualizar_kardex($kardex);
            if(isset($respuesta['code'])){
              $data['productos'] = $this->model_productos->listar();   
              $this->session->set_flashdata('msg', '<div class="alert alert-error text-center">'.$respuesta['message'].'</div>');
              $this->load->view('header'); 
              $this->model_seguridad->SessionActivo();    
              $this->load->view('view_baja',$data);
              $this->load->view('footer');
                
            }else{

              $this->session->set_flashdata('msg','Se ha guardado');
              redirect("?c=almacen&m=baja&me=".$this->me."&sme=".$this->sme);
            }
          }else{
            $this->load->view('header'); 
            $this->model_seguridad->SessionActivo();
            $data['productos'] = $this->model_productos->listar_activos_almacen($id_almacen); 
            $data['productos_baja'] = $this->model_productos->listar_baja();    
            $this->load->view('view_baja',$data);
            $this->load->view('footer');
          }

          
     }
     public function solicitudes_productos(){
          $this->load->library('session');
          $this->load->view('header'); 
          $this->model_seguridad->SessionActivo();
          $data['productos'] = $this->model_comprobantes_detalles->listar_pedidos_detalles();  
          $this->load->view('view_almacen_solicitudes_pendientes',$data);
          $this->load->view('footer');
     }
     public function ingresos(){
          $this->load->library('session');
          if($this->input->post()){
            $data = array(
              'cmp_igv' =>'18',
              'cmp_id_pe' => $this->input->post('hi_persona'),
              'cmp_serie' => $this->input->post('tx_serie'),
              'cmp_numero' => $this->input->post('tx_nfactura'),
              'cmp_id_tpc' => $this->input->post('sl_tipo'),
              'cmp_fecha' => $this->input->post('tx_fecha'),
              'cmp_id_us_reg' => $this->session->userdata('us_id'),
              
            );

            $respuesta = $this->model_comprobantes->guardar($data,$this->input->post('hi_productos'),$this->input->post('hi_pedidos'));
            if(isset($respuesta['code'])){
              $data['pedidos'] = $this->model_comprobantes->listar_pedidos(); 
              $this->session->set_flashdata('msg', '<div class="alert alert-error text-center">'.$respuesta['message'].'</div>');
              $this->load->view('header'); 
              $this->model_seguridad->SessionActivo();    
              $this->load->view('view_almacen_entradas_pendientes',$data);
              $this->load->view('footer');
                
            }else{
              $this->session->set_flashdata('msg','Se ha guardado');
              redirect("?c=almacen&m=ingresos&me=".$this->me."&sme=".$this->sme);
            }
            
          }
          else{
            $this->load->view('header'); 
            $this->model_seguridad->SessionActivo();
            $data['tipos'] = $this->model_tipos->listar();  
            $data['pedidos'] = $this->model_comprobantes->listar_pedidos(); 
            $this->load->view('view_almacen_entradas_pendientes',$data);
            $this->load->view('footer');
          }
          
     }
     public function atendido(){
        $this->load->library('session');
        $id_cde = $this->input->get('i');
        $ipd = $this->input->get('ipd');
        $tipo_io = 'O';
        $estado = ($this->input->get('cant')==$this->input->get('cant_rq'))?2:3;
        $data = array(
            'cde_observaciones' => utf8_encode(strtoupper($this->input->get('obs'))),
            'cde_cantidad_almacen' => $this->input->get('cant'),
            'cde_estado' => $estado 
        );
        $data_stock = array(
            'als_tipo' => $tipo_io,
            'als_id_al' => 1,
            'als_id_pd' => $ipd,
            'als_cantidad' => $this->input->get('cant'),
            'als_id_cde' => $id_cde,
            'als_id_pe' => $this->input->get('pe'),
            'als_id_us_reg' => $this->ius,
            'als_observacion' => utf8_encode(strtoupper($this->input->get('obs'))),
        );
        $this->db->trans_start();
        $resultado = $this->model_comprobantes_detalles->actualizar($id_cde , $data);
        $resultado_producto = $this->model_productos->actualizar_stock($ipd , $this->input->get('cant'),$tipo_io);
        $resultado_stock = $this->model_almacenes_stocks->guardar($data_stock);
        
        echo json_encode($resultado); 
        $this->db->trans_complete();
     }
     public function remover_pedido(){
        $this->load->library('session');
        $id = $this->input->get('i');
        $data = array(
            'cde_observaciones' => utf8_encode(strtoupper($this->input->get('obs'))),
            'cde_estado' => 0 
        );
   
        $this->db->trans_start();
        $resultado = $this->model_comprobantes_detalles->actualizar($id , $data);
        $this->db->trans_complete();
        echo json_encode($resultado); 
     }
     public function recibido(){
        $this->load->library('session');
        $id = $this->input->get('i');
        $ipd = $this->input->get('ipd');
        $tipo_io = 'I';
        $estado = ($this->input->get('cant')==$this->input->get('cant_rq'))?2:3;
        $data = array(
            'cde_observaciones' => utf8_encode(strtoupper($this->input->get('obs'))),
            'cde_cantidad_almacen' => $this->input->get('cant'),
            'cde_estado' => $estado 
        );
        $data_stock = array(
            'als_tipo' => $tipo_io,
            'als_id_al' => 1,
            'als_id_pd' => $ipd,
            'als_cantidad' => $this->input->get('cant'),
            'als_id_cde' => $id,
            'als_id_pe' => $this->input->get('pe'),
            'als_id_us_reg' => $this->ius,
        );
    
        $this->db->trans_start();
        $resultado = $this->model_comprobantes_detalles->actualizar($id , $data);
        $resultado_producto = $this->model_productos->actualizar_stock($ipd , $this->input->get('cant'),$tipo_io);
        $resultado_stock = $this->model_almacenes_stocks->guardar($data_stock);
        $this->db->trans_complete();
        echo json_encode($resultado); 
     }

     public function confirmar(){
        // por parte del personal de operaciones
        $this->load->library('session');
        $id = $this->input->get('i');

        $data = array(
            'cde_estado_operaciones' => 2 
        );
       
    
        $this->db->trans_start();
        $resultado = $this->model_comprobantes_detalles->actualizar($id , $data);
        
        $this->db->trans_complete();
        echo json_encode($resultado); 
     }

     public function salidas(){
          $this->load->library('session');
          $this->load->view('header'); 
          $this->model_seguridad->SessionActivo();
          
          $this->load->view('view_almacen_salidas');
          $this->load->view('footer');
     }
     public function entradas(){
          $this->load->library('session');
          $this->load->view('header'); 
          $this->model_seguridad->SessionActivo();
          $this->load->view('view_almacen_entradas');
          $this->load->view('footer');
     }
     public function proveedores(){
          $this->load->library('session');
          $this->load->view('header'); 
          $this->model_seguridad->SessionActivo();
          $this->load->view('view_almacen_proveedores');
          $this->load->view('footer');
     }
     public function compras(){
          $this->load->library('session');
          $this->load->view('header'); 
          $this->model_seguridad->SessionActivo();
          $this->load->view('view_almacen_compras');
          $this->load->view('footer');
     }
     public function recepcionar_productos(){
        $this->model_seguridad->SessionActivo();
        //$data['productos'] = $this->model_productos->listar_activos(); 
        $data['areas'] = $this->model_areas->listar_xtipo(2);     
        //$data['tipos'] = $this->model_tipos->listar();  
        $data['pedidos'] = $this->model_ordenes_compras_detalles->listar_xfecha($this->f); 
        $this->load->view('view_almacenes_recepcionar_productos', $data);
      }
      public function recibido_conforme(){
        $this->load->library('session');       
        $iode = $this->input->get('i');
        $ial = $this->input->get('ial');//almacen
        $ipd = $this->input->get('ipd');
        $iun = $this->input->get('iun');
        $cantidad = $this->input->get('cantidad');
        $producto = $this->model_productos->registro($ipd);
        if ($producto->pd_id_padre) {
          $ipd = $producto->pd_id_padre;
          $iun = $producto->pd_cantidad_id_un;
          $cantidad = $cantidad*$producto->pd_cantidad;
        }
        $estado = ($this->input->get('cantidad')==$this->input->get('cantidad_rq'))?6:5;
        $data = array(
            'ode_estado' => $estado, 
            'ode_recibido_fecha' => date('Y-m-d h:i:s'),
            'ode_recibido_id_us' => $this->ius,
            'ode_recibido_observaciones' => $this->input->get('observaciones'),
            'ode_recibido_cantidad' => $this->input->get('cantidad'),
        );
        
        $kardex = array(
              'kx_id_al'=>$this->input->get('ial'),
              'kx_operacion' =>'E',
              'kx_tipo' =>'C',
              'kx_id_pd'=>$ipd,
              'kx_cantidad'=>$cantidad,
              'kx_id_un'=>$iun,
              'kx_observacion' =>$this->input->get('observaciones'),
              'kx_id_us_reg' =>$this->ius,
              'kx_fecha' =>date('Y-m-d H:i:s'),
        );
       // $this->db->trans_start();
        $resultado = $this->model_ordenes_compras_detalles->actualizar($iode, $data);
        $this->model_kardex->guardar($kardex);
        //$this->db->trans_complete();
        echo json_encode($resultado); 
     }
     public function orden_compra_anular(){
        // revisar funcionamiento
        $this->load->library('session');
       
        $data = array(
            'ode_estado' => 9
        );
       
        $this->db->trans_start();

     
        $resultado = $this->model_comprobantes_detalles->actualizar($this->input->get('i'), $data);
        $this->db->trans_complete();
        echo json_encode($resultado); 
     }
}


?>